/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster;

import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.io.input.file.FileWithDirectoryInput;
import org.anchoranalysis.math.statistics.MeanScale;
import org.anchoranalysis.math.statistics.VarianceCalculatorDouble;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.TimestampedFile;
import org.anchoranalysis.plugin.io.bean.file.pattern.TimestampPattern;

class DeriveTimestampedFiles {
    private final List<TimestampPattern> dateTimePatterns;
    private MeanScale scaler;

    public List<TimestampedFile> derive(List<FileWithDirectoryInput> inputs, ZoneOffset offset) throws OperationFailedException {
        VarianceCalculatorDouble varianceCalculator = new VarianceCalculatorDouble();
        try {
            List extracted = FunctionalList.mapToList(inputs, CreateException.class, input -> new TimestampedFile(input.getFile(), varianceCalculator, this.dateTimePatterns, offset));
            this.scaler = DeriveTimestampedFiles.deriveScaler(varianceCalculator);
            extracted.forEach(attributes -> attributes.normalize(this.scaler));
            return extracted;
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public MeanScale getScaler() throws OperationFailedException {
        return Optional.ofNullable(this.scaler).orElseThrow(() -> new OperationFailedException("No scaler is yet available"));
    }

    private static MeanScale deriveScaler(VarianceCalculatorDouble varianceCalculator) {
        double stdDev = Math.sqrt(varianceCalculator.variance());
        return new MeanScale(varianceCalculator.mean(), stdDev);
    }

    public DeriveTimestampedFiles(List<TimestampPattern> dateTimePatterns) {
        this.dateTimePatterns = dateTimePatterns;
    }
}

