/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.group;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.io.bean.channel.ChannelMapCreator;
import org.anchoranalysis.image.io.bean.stack.reader.InputManagerWithStackReader;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInput;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.namer.FileNamer;
import org.anchoranalysis.io.input.file.FileInput;
import org.anchoranalysis.io.input.file.FileNamerContext;
import org.anchoranalysis.io.input.file.NamedFile;
import org.anchoranalysis.plugin.io.bean.file.group.GroupFilesMap;
import org.anchoranalysis.plugin.io.bean.file.group.GroupingInput;
import org.anchoranalysis.plugin.io.bean.file.group.check.CheckParsedFilePathBag;
import org.anchoranalysis.plugin.io.bean.file.group.parser.FilePathParser;
import org.anchoranalysis.plugin.io.bean.file.namer.LastDirectories;
import org.anchoranalysis.plugin.io.bean.input.files.NamedFiles;
import org.anchoranalysis.plugin.io.multifile.FileDetails;
import org.anchoranalysis.plugin.io.multifile.OpenedMultiFile;
import org.anchoranalysis.plugin.io.multifile.ParsedFilePathBag;

public class GroupFiles
extends InputManagerWithStackReader<NamedChannelsInput> {
    @BeanField
    private NamedFiles fileInput;
    @BeanField
    private FilePathParser pathParser;
    @BeanField
    private boolean requireAllFilesMatch = false;
    @BeanField
    private ChannelMapCreator imgChannelMapCreator;
    @BeanField
    private FileNamer namer = new LastDirectories(2);
    @BeanField
    @OptionalBean
    private CheckParsedFilePathBag checkParsedFilePathBag;

    public InputsWithDirectory<NamedChannelsInput> inputs(InputManagerParameters parameters) throws InputReadFailedException {
        InputsWithDirectory<FileInput> inputs = this.fileInput.inputs(parameters);
        GroupFilesMap map = new GroupFilesMap();
        for (FileInput input : inputs) {
            Optional<FileDetails> details = this.pathParser.parsePath(input.getFile().toPath());
            if (details.isPresent()) {
                map.add(this.pathParser.getKey(), details.get());
                continue;
            }
            if (!this.requireAllFilesMatch) continue;
            throw new InputReadFailedException(String.format("File %s did not match parser", input.getFile().toPath()));
        }
        return inputs.withInputs(this.listFromMap(map, parameters.getExecutionTimeRecorder(), parameters.getLogger()));
    }

    private List<NamedChannelsInput> listFromMap(GroupFilesMap map, ExecutionTimeRecorder executionTimeRecorder, Logger logger) throws InputReadFailedException {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<OpenedMultiFile> openedFiles = new ArrayList<OpenedMultiFile>();
        for (String key : map.keySet()) {
            ParsedFilePathBag bag = map.get(key);
            if (this.checkParsedFilePathBag != null && !this.checkParsedFilePathBag.accept(bag)) continue;
            files.add(Paths.get(key, new String[0]).toFile());
            openedFiles.add(new OpenedMultiFile(this.getStackReader(), bag, executionTimeRecorder));
        }
        List namedFiles = this.namer.deriveNameUnique(files, new FileNamerContext(logger));
        return this.zipIntoGrouping(namedFiles, openedFiles);
    }

    private List<NamedChannelsInput> zipIntoGrouping(List<NamedFile> files, List<OpenedMultiFile> openedFiles) {
        Iterator<NamedFile> iterator1 = files.iterator();
        Iterator<OpenedMultiFile> iterator2 = openedFiles.iterator();
        ArrayList<NamedChannelsInput> result = new ArrayList<NamedChannelsInput>();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            result.add(new GroupingInput(iterator1.next().getFile().toPath(), iterator2.next(), this.imgChannelMapCreator));
        }
        return result;
    }

    public NamedFiles getFileInput() {
        return this.fileInput;
    }

    public void setFileInput(NamedFiles fileInput) {
        this.fileInput = fileInput;
    }

    public FilePathParser getPathParser() {
        return this.pathParser;
    }

    public void setPathParser(FilePathParser pathParser) {
        this.pathParser = pathParser;
    }

    public boolean isRequireAllFilesMatch() {
        return this.requireAllFilesMatch;
    }

    public void setRequireAllFilesMatch(boolean requireAllFilesMatch) {
        this.requireAllFilesMatch = requireAllFilesMatch;
    }

    public ChannelMapCreator getImgChannelMapCreator() {
        return this.imgChannelMapCreator;
    }

    public void setImgChannelMapCreator(ChannelMapCreator imgChannelMapCreator) {
        this.imgChannelMapCreator = imgChannelMapCreator;
    }

    public FileNamer getNamer() {
        return this.namer;
    }

    public void setNamer(FileNamer namer) {
        this.namer = namer;
    }

    public CheckParsedFilePathBag getCheckParsedFilePathBag() {
        return this.checkParsedFilePathBag;
    }

    public void setCheckParsedFilePathBag(CheckParsedFilePathBag checkParsedFilePathBag) {
        this.checkParsedFilePathBag = checkParsedFilePathBag;
    }
}

