/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.group;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.channel.ChannelMapCreator;
import org.anchoranalysis.image.io.channel.input.ChannelMap;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInput;
import org.anchoranalysis.image.io.channel.map.NamedChannelsMap;
import org.anchoranalysis.image.io.channel.map.OpenedNamedChannels;
import org.anchoranalysis.image.io.stack.input.ImageTimestampsAttributes;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;

class GroupingInput
extends NamedChannelsInput {
    private final Path virtualPath;
    private final OpenedImageFile openedFile;
    private final ChannelMapCreator channelMapCreator;
    private ChannelMap channelMap;
    private String inputName;

    public int numberSeries() throws ImageIOException {
        return this.openedFile.numberSeries();
    }

    public Dimensions dimensions(int stackIndexInSeries, Logger logger) throws ImageIOException {
        return this.openedFile.dimensionsForSeries(stackIndexInSeries, logger);
    }

    public NamedChannelsMap createChannelsForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        this.ensureChannelMapExists(logger);
        return new OpenedNamedChannels(this.openedFile, this.channelMap, seriesIndex);
    }

    public String identifier() {
        return this.inputName;
    }

    public Optional<Path> pathForBinding() {
        return Optional.of(this.virtualPath);
    }

    public int numberChannels(Logger logger) throws ImageIOException {
        this.ensureChannelMapExists(logger);
        return this.channelMap.names().size();
    }

    public int bitDepth(Logger logger) throws ImageIOException {
        return this.openedFile.bitDepth(logger);
    }

    public ImageMetadata metadata(int seriesIndex, Logger logger) throws ImageIOException {
        NamedChannelsMap channels = this.createChannelsForSeries(seriesIndex, logger);
        ImageTimestampsAttributes timestamps = this.openedFile.timestamps();
        return new ImageMetadata(channels.dimensions(logger), this.numberChannels(logger), this.numberFrames(), this.numberSeries(), channels.isRGB(logger), this.bitDepth(logger), timestamps.getAttributes(), timestamps.getAcqusitionTime(), Optional.empty());
    }

    public void close(ErrorReporter errorReporter) {
        try {
            this.openedFile.close();
        }
        catch (ImageIOException e) {
            errorReporter.recordError(GroupingInput.class, (Throwable)e);
        }
    }

    private void ensureChannelMapExists(Logger logger) throws ImageIOException {
        if (this.channelMap == null) {
            try {
                this.channelMap = this.channelMapCreator.create(this.openedFile, logger);
            }
            catch (CreateException e) {
                throw new ImageIOException("Failed to create a channel-map", (Throwable)e);
            }
        }
    }

    public GroupingInput(Path virtualPath, OpenedImageFile openedFile, ChannelMapCreator channelMapCreator) {
        this.virtualPath = virtualPath;
        this.openedFile = openedFile;
        this.channelMapCreator = channelMapCreator;
    }
}

