/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.group.parser;

import java.util.Optional;
import java.util.regex.Matcher;

class ExtractGroup {
    public static Optional<String> extractString(int groupID, Matcher matcher) {
        if (groupID > matcher.groupCount()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(groupID));
    }

    public static int maybeExtractInt(int groupID, Matcher matcher) {
        if (groupID > 0) {
            return ExtractGroup.extractInt(groupID, matcher);
        }
        return 0;
    }

    private static int extractInt(int groupID, Matcher matcher) {
        if (groupID > matcher.groupCount()) {
            return -1;
        }
        Optional<String> groupText = ExtractGroup.extractString(groupID, matcher);
        return groupText.map(Integer::parseInt).orElse(-1);
    }

    private ExtractGroup() {
    }
}

