/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.namer;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.io.input.bean.namer.FileNamerIndependent;

public class LastDirectories
extends FileNamerIndependent {
    @BeanField
    private int numberSubdirectories = 0;
    @BeanField
    private boolean removeExtensionInDescription = true;
    @BeanField
    private int skipNumberSubdirectories = 0;
    @BeanField
    private boolean skipFileName = false;

    public LastDirectories(int numberSubdirectories) {
        this.numberSubdirectories = numberSubdirectories;
    }

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.skipFileName && this.numberSubdirectories <= 0) {
            throw new BeanMisconfiguredException("If skipFileName is true, numberSubdirectories must be greater than 0");
        }
    }

    protected String deriveName(File file, Optional<Path> inputDirectory, int index) {
        String nameOut = "";
        if (!this.skipFileName) {
            nameOut = this.maybeRemoveExtension(file);
        }
        File currentFile = file;
        for (int i = 0; i < this.numberSubdirectories && (currentFile = currentFile.getParentFile()) != null; ++i) {
            if (i < this.skipNumberSubdirectories) continue;
            nameOut = this.prependMaybeWithSlash(currentFile.getName(), nameOut);
        }
        return nameOut;
    }

    private String prependMaybeWithSlash(String prepend, String existing) {
        if (existing.isEmpty()) {
            return prepend;
        }
        return prepend + "/" + existing;
    }

    private String maybeRemoveExtension(File file) {
        if (this.removeExtensionInDescription) {
            return ExtensionUtilities.filenameWithoutExtension((File)file);
        }
        return file.getName();
    }

    public LastDirectories() {
    }

    public int getNumberSubdirectories() {
        return this.numberSubdirectories;
    }

    public void setNumberSubdirectories(int numberSubdirectories) {
        this.numberSubdirectories = numberSubdirectories;
    }

    public boolean isRemoveExtensionInDescription() {
        return this.removeExtensionInDescription;
    }

    public void setRemoveExtensionInDescription(boolean removeExtensionInDescription) {
        this.removeExtensionInDescription = removeExtensionInDescription;
    }

    public int getSkipNumberSubdirectories() {
        return this.skipNumberSubdirectories;
    }

    public void setSkipNumberSubdirectories(int skipNumberSubdirectories) {
        this.skipNumberSubdirectories = skipNumberSubdirectories;
    }

    public boolean isSkipFileName() {
        return this.skipFileName;
    }

    public void setSkipFileName(boolean skipFileName) {
        this.skipFileName = skipFileName;
    }
}

