/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.namer;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.input.bean.namer.FileNamerIndependent;

public class RelativeToDirectory
extends FileNamerIndependent {
    protected String deriveName(File file, Optional<Path> inputDirectory, int index) throws CreateException {
        if (inputDirectory.isPresent()) {
            Path inputDirectoryAbsolute = RelativeToDirectory.makeAbsoluteNormalized(inputDirectory.get());
            Path fileAbsolute = RelativeToDirectory.makeAbsoluteNormalized(file.toPath());
            return FilePathToUnixStyleConverter.toStringUnixStyle((Path)inputDirectoryAbsolute.relativize(fileAbsolute));
        }
        throw new CreateException("Cannot derive a name as no input-directory is defined, as is required.");
    }

    private static Path makeAbsoluteNormalized(Path path) {
        return path.toAbsolutePath().normalize();
    }
}

