/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.namer;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.io.input.bean.namer.FileNamer;
import org.anchoranalysis.io.input.file.FileNamerContext;
import org.anchoranalysis.io.input.file.NamedFile;

public class SubsetRangeIfRequested
extends FileNamer {
    @BeanField
    private FileNamer namer;
    @BeanField
    private String delimiter = "/";

    public List<NamedFile> deriveName(List<File> files, FileNamerContext context) {
        List namedFiles = this.namer.deriveName(files, context);
        if (context.getNameSubrange().isPresent()) {
            return FunctionalList.mapToList((Collection)namedFiles, OperationFailedException.class, file -> this.subsetFile((NamedFile)file, (IndexRangeNegative)context.getNameSubrange().get(), context.getLogger().errorReporter()));
        }
        return namedFiles;
    }

    private NamedFile subsetFile(NamedFile namedFile, IndexRangeNegative range, ErrorReporter errorReporter) {
        return namedFile.mapIdentifier((name, file) -> this.subsetName((String)name, range, errorReporter));
    }

    private String subsetName(String name, IndexRangeNegative range, ErrorReporter errorReporter) {
        List<String> groups = this.splitName(name);
        try {
            List subset = range.extract(groups);
            return String.join((CharSequence)this.delimiter, subset);
        }
        catch (OperationFailedException e) {
            errorReporter.recordError(SubsetRangeIfRequested.class, String.format("Cancelling subset of names for %s. Reverting to original name.%n%s", name, e.getMessage()));
            return name;
        }
    }

    private List<String> splitName(String name) {
        return Arrays.asList(name.split(this.delimiter));
    }

    public FileNamer getNamer() {
        return this.namer;
    }

    public void setNamer(FileNamer namer) {
        this.namer = namer;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

