/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.namer.patternspan;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.owenfeehan.pathpatternfinder.Pattern;
import com.owenfeehan.pathpatternfinder.patternelements.PatternElement;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;

class ExtractVariableSpan {
    private Pattern pattern;
    private String elseName;
    private int indexSpanStart;
    private int indexSpanEnd;

    public String extractConstantElementBeforeSpanPortion() {
        if (this.indexSpanStart == 0) {
            return this.elseName;
        }
        PatternElement element = this.pattern.get(this.indexSpanStart - 1);
        assert (element.hasConstantValue());
        return element.valueAt(0);
    }

    public String extractSpanPortionFor(int fileIndex) {
        return FilePathToUnixStyleConverter.toStringUnixStyle((String)this.extractTrimmedFromBothSides(fileIndex));
    }

    private String extractTrimmedFromBothSides(int fileIndex) {
        CharSequence[] elements = this.pattern.valuesAt(fileIndex, this.indexSpanStart, this.indexSpanEnd + 1);
        Preconditions.checkArgument((elements.length == this.indexSpanEnd - this.indexSpanStart + 1 ? 1 : 0) != 0);
        return String.join((CharSequence)"", elements);
    }

    public ExtractVariableSpan(Pattern pattern, String elseName, int indexSpanStart, int indexSpanEnd) {
        this.pattern = pattern;
        this.elseName = elseName;
        this.indexSpanStart = indexSpanStart;
        this.indexSpanEnd = indexSpanEnd;
    }
}

