/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.namer.patternspan;

import com.owenfeehan.pathpatternfinder.PathPatternFinder;
import com.owenfeehan.pathpatternfinder.Pattern;
import com.owenfeehan.pathpatternfinder.patternelements.PatternElement;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.io.input.bean.namer.FileNamer;
import org.anchoranalysis.io.input.file.FileNamerContext;
import org.anchoranalysis.io.input.file.NamedFile;
import org.anchoranalysis.plugin.io.bean.file.namer.patternspan.ExtractVariableSpan;
import org.anchoranalysis.plugin.io.bean.file.namer.patternspan.ExtractVariableSpanForList;
import org.anchoranalysis.plugin.io.bean.file.namer.patternspan.SelectSpanToExtract;
import org.apache.commons.io.IOCase;

public class PatternSpan
extends FileNamer {
    @BeanField
    private boolean caseSensitive = false;

    public List<NamedFile> deriveName(List<File> files, FileNamerContext context) {
        List<Path> paths = PatternSpan.convertToList(files);
        if (paths.size() <= 1) {
            return PatternSpan.extractFileNames(files);
        }
        IOCase ioCase = this.createCaseSensitivity();
        Pattern pattern = PathPatternFinder.findPatternPaths(paths, (IOCase)ioCase, (boolean)true);
        if (!PatternSpan.hasAtLeastOneVariableElement(pattern)) {
            throw new AnchorImpossibleSituationException();
        }
        return PatternSpan.extractFromPattern(pattern, files, context);
    }

    private IOCase createCaseSensitivity() {
        return this.caseSensitive ? IOCase.SENSITIVE : IOCase.INSENSITIVE;
    }

    private static List<NamedFile> extractFromPattern(Pattern pattern, List<File> files, FileNamerContext context) {
        ExtractVariableSpan extracter = new SelectSpanToExtract(pattern, context.getNameSubrange()).selectSpanToExtract(context.getElseName());
        return ExtractVariableSpanForList.listExtract(files, extracter);
    }

    private static boolean hasAtLeastOneVariableElement(Pattern pattern) {
        for (PatternElement element : pattern) {
            if (element.hasConstantValue()) continue;
            return true;
        }
        return false;
    }

    private static List<NamedFile> extractFileNames(Collection<File> files) {
        return FunctionalList.mapToList(files, file -> new NamedFile(ExtensionUtilities.filenameWithoutExtension((File)file), file));
    }

    private static List<Path> convertToList(Collection<File> files) {
        return FunctionalList.mapToList(files, File::toPath);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

