/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.path.prefixer;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.core.system.path.PathDifference;
import org.anchoranalysis.core.system.path.PathDifferenceException;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixerAvoidResolve;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.NamedPath;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;

public class DirectoryStructure
extends PathPrefixerAvoidResolve {
    @BeanField
    private boolean includeDirectories = true;
    @BeanField
    @AllowEmpty
    private String prefixToRemove = "";

    public DirectoryWithPrefix outFilePrefixFromPath(NamedPath path, Path root, PathPrefixerContext context) throws PathPrefixerException {
        Path pathWithoutExtension = ExtensionUtilities.removeExtension((Path)path.getPath());
        PathDifference difference = this.differenceToPrefix(pathWithoutExtension);
        return new DirectoryWithPrefix(this.buildOutPath(root, difference));
    }

    private PathDifference differenceToPrefix(Path pathInRemoved) throws PathPrefixerException {
        try {
            return PathDifference.differenceFrom((Path)Paths.get(this.prefixToRemove, new String[0]), (Path)pathInRemoved);
        }
        catch (PathDifferenceException e) {
            throw new PathPrefixerException((Throwable)e);
        }
    }

    private Path buildOutPath(Path root, PathDifference difference) {
        if (this.includeDirectories) {
            return root.resolve(difference.combined());
        }
        return root.resolve(difference.getFilename());
    }

    public boolean isIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setIncludeDirectories(boolean includeDirectories) {
        this.includeDirectories = includeDirectories;
    }

    public String getPrefixToRemove() {
        return this.prefixToRemove;
    }

    public void setPrefixToRemove(String prefixToRemove) {
        this.prefixToRemove = prefixToRemove;
    }
}

