/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.path.prefixer;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.system.path.PathDifferenceException;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixer;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixerAvoidResolve;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.NamedPath;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;
import org.anchoranalysis.plugin.io.input.path.RootPathMap;

public class Rooted
extends PathPrefixer {
    @BeanField
    private PathPrefixerAvoidResolve prefixer;
    @BeanField
    private String rootName;

    public DirectoryWithPrefix outFilePrefix(NamedPath path, Optional<String> experimentName, PathPrefixerContext context) throws PathPrefixerException {
        DirectoryWithPrefix directoryWithPrefix = this.prefixer.outFilePrefixAvoidResolve(this.removeRoot(path, context.isDebugMode()), experimentName, context);
        Path pathOut = this.folderPathOut(directoryWithPrefix.getDirectory(), context.isDebugMode());
        directoryWithPrefix.setDirectory(pathOut);
        return directoryWithPrefix;
    }

    private NamedPath removeRoot(NamedPath path, boolean debugMode) throws PathPrefixerException {
        try {
            Path pathWithoutRoot = RootPathMap.instance().split(path.getPath(), this.rootName, debugMode).getRemainder();
            return new NamedPath(path.getName(), pathWithoutRoot);
        }
        catch (PathDifferenceException e) {
            throw new PathPrefixerException((Throwable)e);
        }
    }

    public DirectoryWithPrefix rootDirectoryPrefix(Optional<String> expName, PathPrefixerContext context) throws PathPrefixerException {
        DirectoryWithPrefix fpp = this.prefixer.rootDirectoryPrefixAvoidResolve(expName);
        fpp.setDirectory(this.folderPathOut(fpp.getDirectory(), context.isDebugMode()));
        return fpp;
    }

    private Path folderPathOut(Path pathIn, boolean debugMode) throws PathPrefixerException {
        try {
            return RootPathMap.instance().findRoot(this.rootName, debugMode).asPath().resolve(pathIn);
        }
        catch (PathDifferenceException e) {
            throw new PathPrefixerException((Throwable)e);
        }
    }

    public Rooted() {
    }

    public Rooted(PathPrefixerAvoidResolve prefixer, String rootName) {
        this.prefixer = prefixer;
        this.rootName = rootName;
    }

    public PathPrefixerAvoidResolve getPrefixer() {
        return this.prefixer;
    }

    public void setPrefixer(PathPrefixerAvoidResolve prefixer) {
        this.prefixer = prefixer;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }
}

