/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.pattern;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;

public class TimestampPattern
extends AnchorBean<TimestampPattern> {
    @BeanField
    private String regularExpression;
    @BeanField
    private int indexYear = 0;
    @BeanField
    private int indexMonth = 1;
    @BeanField
    private int indexDay = 2;
    @BeanField
    private int indexHours = 3;
    @BeanField
    private int indexMinutes = 4;
    @BeanField
    private int indexSeconds = 5;
    private Pattern pattern;

    public TimestampPattern(String regularExpression) {
        this.regularExpression = regularExpression;
    }

    public Optional<Long> match(String fileName, ZoneOffset offset) {
        Matcher matcher = this.getPatternMemo().matcher(fileName);
        if (matcher.matches()) {
            int year = TimestampPattern.extractInt(matcher, this.indexYear);
            int month = TimestampPattern.extractInt(matcher, this.indexMonth);
            int day = TimestampPattern.extractInt(matcher, this.indexDay);
            int hours = TimestampPattern.extractInt(matcher, this.indexHours);
            int minutes = TimestampPattern.extractInt(matcher, this.indexMinutes);
            int seconds = TimestampPattern.extractInt(matcher, this.indexSeconds);
            LocalDateTime dateTime = LocalDateTime.of(year, month, day, hours, minutes, seconds);
            return Optional.of(dateTime.toEpochSecond(offset));
        }
        return Optional.empty();
    }

    private Pattern getPatternMemo() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regularExpression);
        }
        return this.pattern;
    }

    private static int extractInt(Matcher matcher, int index) {
        return Integer.parseInt(matcher.group(index + 1));
    }

    public TimestampPattern() {
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
    }

    public int getIndexYear() {
        return this.indexYear;
    }

    public void setIndexYear(int indexYear) {
        this.indexYear = indexYear;
    }

    public int getIndexMonth() {
        return this.indexMonth;
    }

    public void setIndexMonth(int indexMonth) {
        this.indexMonth = indexMonth;
    }

    public int getIndexDay() {
        return this.indexDay;
    }

    public void setIndexDay(int indexDay) {
        this.indexDay = indexDay;
    }

    public int getIndexHours() {
        return this.indexHours;
    }

    public void setIndexHours(int indexHours) {
        this.indexHours = indexHours;
    }

    public int getIndexMinutes() {
        return this.indexMinutes;
    }

    public void setIndexMinutes(int indexMinutes) {
        this.indexMinutes = indexMinutes;
    }

    public int getIndexSeconds() {
        return this.indexSeconds;
    }

    public void setIndexSeconds(int indexSeconds) {
        this.indexSeconds = indexSeconds;
    }
}

