/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.grouper;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.input.bean.grouper.Grouper;
import org.anchoranalysis.io.input.bean.grouper.WithoutGrouping;
import org.anchoranalysis.io.input.grouper.InputGrouper;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.io.input.path.ExtractPathElementRange;

public class IfGroupIndexRange
extends Grouper {
    @BeanField
    private Grouper group = new WithoutGrouping();

    public Optional<InputGrouper> createInputGrouper(Optional<IndexRangeNegative> groupIndexRange) {
        if (groupIndexRange.isPresent()) {
            return Optional.of(identifier -> IfGroupIndexRange.extractSubrange(identifier, (IndexRangeNegative)groupIndexRange.get()));
        }
        return this.group.createInputGrouper(groupIndexRange);
    }

    private static String extractSubrange(Path identifier, IndexRangeNegative groupIndexRange) throws DerivePathException {
        Path extractedPath = ExtractPathElementRange.extract((Path)identifier, (IndexRangeNegative)groupIndexRange);
        return FilePathToUnixStyleConverter.toStringUnixStyle((Path)extractedPath);
    }

    public Grouper getGroup() {
        return this.group;
    }

    public void setGroup(Grouper group) {
        this.group = group;
    }
}

