/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input;

import java.util.ListIterator;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.io.input.bean.InputManagerParameters;

class LimitHelper {
    public static <T> void limitInputsIfNecessary(ListIterator<T> iterator, int keepNumberItems, int totalNumberItems, InputManagerParameters parameters) {
        MessageLogger logger = parameters.getLogger().messageLogger();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            if (count == keepNumberItems) {
                logger.logFormatted("Limiting the number of inputs, by accepting only the first %d inputs from %d.", new Object[]{keepNumberItems, totalNumberItems});
                logger.logEmptyLine();
            }
            if (count >= keepNumberItems) {
                iterator.remove();
            }
            ++count;
        }
    }

    private LimitHelper() {
    }
}

