/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input;

import io.vavr.control.Either;
import java.util.Optional;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.InputManagerUnary;
import org.anchoranalysis.plugin.io.bean.input.LimitHelper;

public class LimitIfRequested<T extends InputFromManager>
extends InputManagerUnary<T> {
    protected InputsWithDirectory<T> inputsFromDelegate(InputsWithDirectory<T> fromDelegate, InputManagerParameters parameters) throws InputReadFailedException {
        int totalNumberInputs = fromDelegate.inputs().size();
        Optional<Integer> option = parameters.getInputContext().getLimitUpper().map(either -> LimitIfRequested.calculateLimit((Either<Integer, Double>)either, totalNumberInputs));
        if (option.isPresent()) {
            LimitHelper.limitInputsIfNecessary(fromDelegate.listIterator(), option.get(), totalNumberInputs, parameters);
        }
        return fromDelegate;
    }

    private static int calculateLimit(Either<Integer, Double> limitUpper, int totalNumberInputs) {
        if (limitUpper.isLeft()) {
            return (Integer)limitUpper.getLeft();
        }
        return (int)Math.round((Double)limitUpper.get() * (double)totalNumberInputs);
    }
}

