/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.files.provider;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.io.input.bean.files.FilesProviderUnary;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.file.FilesProviderException;
import org.anchoranalysis.io.input.path.DerivePathException;

public class FilterForExistingFiles
extends FilesProviderUnary {
    @BeanField
    private List<DerivePath> paths = new ArrayList<DerivePath>();

    protected List<File> transform(List<File> source, boolean debugMode) throws FilesProviderException {
        return FunctionalList.filterToList(source, FilesProviderException.class, file -> this.isFileAccepted((File)file, debugMode));
    }

    private boolean isFileAccepted(File file, boolean debugMode) throws FilesProviderException {
        try {
            for (DerivePath deriver : this.paths) {
                Path derivedPath = deriver.deriveFrom(file.toPath(), debugMode);
                if (derivedPath.toFile().exists()) continue;
                return false;
            }
            return true;
        }
        catch (DerivePathException e) {
            throw new FilesProviderException((Throwable)e);
        }
    }

    public List<DerivePath> getPaths() {
        return this.paths;
    }

    public void setPaths(List<DerivePath> paths) {
        this.paths = paths;
    }
}

