/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.filter;

import java.nio.file.Path;
import java.util.Set;
import java.util.TreeSet;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.io.input.csv.CSVReaderByLine;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.csv.ReadByLine;

class CsvMatcher {
    public static Set<String> rowsFromCsvThatMatch(Path path, String match, int numRowsExpected) throws CSVReaderException {
        TreeSet<String> set = new TreeSet<String>();
        try (ReadByLine csvFile = CSVReaderByLine.open((Path)path, (String)",", (boolean)true, (boolean)true);){
            int count = CsvMatcher.processLines(csvFile, set, match);
            if (count != numRowsExpected) {
                throw new CSVReaderException(String.format("Csv file must have exactly %d rows. It has %d.", numRowsExpected, count));
            }
        }
        return set;
    }

    private static int processLines(ReadByLine csvFile, Set<String> set, String match) throws CSVReaderException {
        return csvFile.read((line, firstLine) -> CsvMatcher.maybeAddLineToSet(set, line, match));
    }

    private static void maybeAddLineToSet(Set<String> set, String[] line, String match) throws OperationFailedException {
        if (line.length != 2) {
            throw new OperationFailedException(String.format("Row must have exactly 2 values. It has %d.", line.length));
        }
        if (line[1].equals(match)) {
            CsvMatcher.addWithDuplicationCheck(set, line[0]);
        }
    }

    private static void addWithDuplicationCheck(Set<String> set, String item) throws OperationFailedException {
        if (!set.add(item)) {
            throw new OperationFailedException(String.format("CSV file contains duplicated values for: %s", item));
        }
    }

    private CsvMatcher() {
    }
}

