/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.filter;

import java.nio.file.Path;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.InputManagerUnary;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.plugin.io.bean.input.filter.CsvMatcher;

public class FilterCSVColumn<T extends InputFromManager>
extends InputManagerUnary<T> {
    @BeanField
    private DerivePath csvFilePath;
    @BeanField
    private String match;

    protected InputsWithDirectory<T> inputsFromDelegate(InputsWithDirectory<T> fromDelegate, InputManagerParameters parameters) throws InputReadFailedException {
        if (fromDelegate.isEmpty()) {
            return fromDelegate;
        }
        try {
            List inputs = fromDelegate.inputs();
            Set<String> matching = this.matchingNames(((InputFromManager)inputs.get(0)).pathForBindingRequired(), parameters.isDebugModeActivated(), inputs.size());
            this.applyFilter(inputs, matching);
            return fromDelegate;
        }
        catch (DerivePathException e) {
            throw new InputReadFailedException((Throwable)e);
        }
    }

    private Set<String> matchingNames(Path pathForGenerator, boolean doDebug, int numRowsExpected) throws DerivePathException {
        Path csvPath = this.csvFilePath.deriveFrom(pathForGenerator, doDebug);
        try {
            return CsvMatcher.rowsFromCsvThatMatch(csvPath, this.match, numRowsExpected);
        }
        catch (CSVReaderException e) {
            throw new DerivePathException("Cannot match rows from csv", (Throwable)e);
        }
    }

    private void applyFilter(List<T> in, Set<String> mustContain) {
        ListIterator<T> itr = in.listIterator();
        while (itr.hasNext()) {
            InputFromManager item = (InputFromManager)itr.next();
            if (mustContain.contains(item.identifier())) continue;
            itr.remove();
        }
    }

    public DerivePath getCsvFilePath() {
        return this.csvFilePath;
    }

    public void setCsvFilePath(DerivePath csvFilePath) {
        this.csvFilePath = csvFilePath;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }
}

