/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.filter;

import java.util.Arrays;
import java.util.List;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.bean.DebugModeParameters;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.InputManagerUnary;
import org.anchoranalysis.plugin.io.input.filter.FilterDescriptiveNameEqualsContains;

public class FilterIfDebug<T extends InputFromManager>
extends InputManagerUnary<T> {
    protected InputsWithDirectory<T> inputsFromDelegate(InputsWithDirectory<T> fromDelegate, InputManagerParameters parameters) throws InputReadFailedException {
        return parameters.getDebugModeParameters().map(parametersToMap -> this.maybeFilterInputs(fromDelegate, (DebugModeParameters)parametersToMap)).orElse(fromDelegate);
    }

    private InputsWithDirectory<T> maybeFilterInputs(InputsWithDirectory<T> fromDelegate, DebugModeParameters debugMode) {
        List<T> filtered = this.takeFirst(this.maybeFilteredList(fromDelegate.inputs(), debugMode));
        return fromDelegate.withInputs(filtered);
    }

    private List<T> takeFirst(List<T> list) {
        if (list.size() <= 1) {
            return list;
        }
        return Arrays.asList((InputFromManager)list.get(0));
    }

    private List<T> maybeFilteredList(List<T> unfiltered, DebugModeParameters debugMode) {
        FilterDescriptiveNameEqualsContains filter = new FilterDescriptiveNameEqualsContains("", debugMode.containsOrEmpty());
        return filter.removeNonMatching(unfiltered);
    }
}

