/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.stack;

import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInput;
import org.anchoranalysis.image.io.channel.map.NamedChannelsMap;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputFromManagerDelegate;

public class ConvertNamedChannelsInputToStack
extends InputFromManagerDelegate<NamedChannelsInput>
implements StackSequenceInput {
    private static final String DEFAULT_STACK_NAME = "stack";
    private int timeIndex = 0;
    private Optional<String> channelName;
    private final ExecutionTimeRecorder executionTimeRecorder;

    public ConvertNamedChannelsInputToStack(NamedChannelsInput input, ExecutionTimeRecorder executionTimeRecorder) {
        this(input, 0, Optional.empty(), executionTimeRecorder);
    }

    public ConvertNamedChannelsInputToStack(NamedChannelsInput input, int timeIndex, Optional<String> channelName, ExecutionTimeRecorder executionTimeRecorder) {
        super((InputFromManager)input);
        this.timeIndex = timeIndex;
        this.channelName = channelName;
        this.executionTimeRecorder = executionTimeRecorder;
    }

    public TimeSeries createStackSequenceForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        try {
            return this.convert((NamedChannelsInput)this.getDelegate(), seriesIndex, logger);
        }
        catch (OperationFailedException e) {
            throw new ImageIOException((Throwable)e);
        }
    }

    public void addToStoreInferNames(NamedProviderStore<TimeSeries> stacks, int seriesIndex, Logger logger) throws OperationFailedException {
        String stackName = this.channelName.orElse(DEFAULT_STACK_NAME);
        this.addConvertedInputToStacks(stackName, stacks, seriesIndex, logger);
    }

    public void addToStoreWithName(String name, NamedProviderStore<TimeSeries> stacks, int seriesIndex, Logger logger) throws OperationFailedException {
        this.addConvertedInputToStacks(name, stacks, seriesIndex, logger);
    }

    public int numberFrames() throws OperationFailedException {
        return ((NamedChannelsInput)this.getDelegate()).numberFrames();
    }

    private TimeSeries convert(NamedChannelsInput input, int seriesIndex, Logger logger) throws OperationFailedException {
        try {
            NamedChannelsMap channels = (NamedChannelsMap)this.executionTimeRecorder.recordExecutionTime("Create channel for series", () -> input.createChannelsForSeries(seriesIndex, logger));
            return (TimeSeries)this.executionTimeRecorder.recordExecutionTime("Derive stack from channels", () -> new TimeSeries(this.stackFromChannels(channels, logger)));
        }
        catch (ImageIOException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private void addConvertedInputToStacks(String name, NamedProviderStore<TimeSeries> stacks, int seriesIndex, Logger logger) throws OperationFailedException {
        stacks.add(name, () -> this.convert((NamedChannelsInput)this.getDelegate(), seriesIndex, logger));
    }

    private Stack stackFromChannels(NamedChannelsMap channels, Logger logger) throws OperationFailedException {
        try {
            if (this.channelName.isPresent()) {
                return new Stack(this.extractChannel(channels, this.channelName.get(), logger));
            }
            if (channels.isRGB(logger) && channels.numberChannels() == 3) {
                return this.buildStackFromRGBChannelNames(channels, logger);
            }
            return (Stack)channels.allChannelsAsStack(this.timeIndex, logger).get();
        }
        catch (GetOperationFailedException | ImageIOException e) {
            throw new OperationFailedException(e);
        }
    }

    private Stack buildStackFromRGBChannelNames(NamedChannelsMap channels, Logger logger) throws OperationFailedException {
        try {
            return new Stack(true, new Channel[]{this.extractChannel(channels, "red", logger), this.extractChannel(channels, "green", logger), this.extractChannel(channels, "blue", logger)});
        }
        catch (CreateException | IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
        catch (GetOperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private Channel extractChannel(NamedChannelsMap channels, String channelName, Logger logger) throws GetOperationFailedException {
        return channels.getChannel(channelName, this.timeIndex, logger);
    }
}

