/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.stack;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.io.input.file.FileInput;

class StackCollectionFromFilesInputObject
implements StackSequenceInput {
    private final FileInput delegate;
    private final StackReader stackReader;
    private final boolean useLastSeriesIndexOnly;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private final Logger logger;
    private OpenedImageFile openedFileMemo;

    public int numberSeries() throws ImageIOException {
        if (this.useLastSeriesIndexOnly) {
            return 1;
        }
        return this.getOpenedRaster().numberSeries();
    }

    public int numberFrames() throws OperationFailedException {
        try {
            return this.getOpenedRaster().numberFrames(this.logger);
        }
        catch (ImageIOException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public TimeSeries createStackSequenceForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        if (this.useLastSeriesIndexOnly) {
            seriesIndex = this.getOpenedRaster().numberSeries() - 1;
        }
        return this.openRasterAsOperation(this.getOpenedRaster(), seriesIndex);
    }

    public void addToStoreInferNames(NamedProviderStore<TimeSeries> stackCollection, int seriesIndex, Logger logger) throws OperationFailedException {
        throw new OperationFailedException("Not supported");
    }

    public void addToStoreWithName(String name, NamedProviderStore<TimeSeries> stacks, int seriesIndex, Logger logger) throws OperationFailedException {
        stacks.add(name, () -> {
            try {
                return this.createStackSequenceForSeries(seriesIndex, logger);
            }
            catch (ImageIOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        });
    }

    public String identifier() {
        return this.delegate.identifier();
    }

    public Optional<Path> pathForBinding() {
        return this.delegate.pathForBinding();
    }

    public File getFile() {
        return this.delegate.getFile();
    }

    public void close(ErrorReporter errorReporter) {
        if (this.openedFileMemo != null) {
            try {
                this.openedFileMemo.close();
            }
            catch (ImageIOException e) {
                errorReporter.recordError(StackSequenceInput.class, (Throwable)e);
            }
        }
    }

    private OpenedImageFile getOpenedRaster() throws ImageIOException {
        if (this.openedFileMemo == null) {
            this.openedFileMemo = this.stackReader.openFile((Path)this.delegate.pathForBinding().orElseThrow(() -> new ImageIOException("A binding-path must be associated with this file")), this.executionTimeRecorder);
        }
        return this.openedFileMemo;
    }

    private TimeSeries openRasterAsOperation(OpenedImageFile openedFile, int seriesIndex) throws ImageIOException {
        return openedFile.open(seriesIndex, this.logger);
    }

    public StackCollectionFromFilesInputObject(FileInput delegate, StackReader stackReader, boolean useLastSeriesIndexOnly, ExecutionTimeRecorder executionTimeRecorder, Logger logger) {
        this.delegate = delegate;
        this.stackReader = stackReader;
        this.useLastSeriesIndexOnly = useLastSeriesIndexOnly;
        this.executionTimeRecorder = executionTimeRecorder;
        this.logger = logger;
    }

    public StackReader getStackReader() {
        return this.stackReader;
    }
}

