/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.metadata.header;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.bmp.BmpHeaderDirectory;
import java.util.Optional;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.core.stack.ImageFileAttributes;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.io.bioformats.metadata.ReadMetadataUtilities;
import org.anchoranalysis.plugin.io.bean.metadata.header.HeaderFormat;
import org.anchoranalysis.plugin.io.bean.metadata.header.MetadataFactory;
import org.anchoranalysis.spatial.box.Extent;

public class BMP
extends HeaderFormat {
    @Override
    protected ImageFileFormat format() {
        return ImageFileFormat.BMP;
    }

    @Override
    protected Optional<ImageMetadata> populateFromMetadata(Metadata metadata, ImageFileAttributes attributes) throws ImageIOException {
        Directory directory = metadata.getFirstDirectoryOfType(BmpHeaderDirectory.class);
        if (directory == null) {
            return Optional.empty();
        }
        Optional extent = ReadMetadataUtilities.readFromWidthHeightTags((Directory)directory, (int)2, (int)1);
        if (!extent.isPresent()) {
            return Optional.empty();
        }
        Optional bitDepth = ReadMetadataUtilities.readInt((Directory)directory, (int)4);
        if (!bitDepth.isPresent()) {
            return Optional.empty();
        }
        switch ((Integer)bitDepth.get()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return BMP.createMetadata((Extent)extent.get(), 1, 8, attributes);
            }
            case 16: {
                return BMP.createMetadata((Extent)extent.get(), 2, 8, attributes);
            }
            case 24: {
                return BMP.createMetadata((Extent)extent.get(), 3, 8, attributes);
            }
            case 32: {
                return BMP.createMetadata((Extent)extent.get(), 4, 8, attributes);
            }
        }
        throw new ImageIOException(String.format("Unrecognised bitsPerPixel of %d", bitDepth.get()));
    }

    private static Optional<ImageMetadata> createMetadata(Extent extent, int numberChannels, int pixelDepth, ImageFileAttributes timestamps) {
        return Optional.of(MetadataFactory.createMetadata(extent, numberChannels, pixelDepth, timestamps));
    }
}

