/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.metadata.header;

import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.util.Optional;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.image.core.dimensions.OrientationChange;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.io.bioformats.metadata.ReadMetadataUtilities;
import org.anchoranalysis.spatial.box.Extent;

class FromExifIfPossible {
    public static Optional<Extent> inferExtentFromEXIFOr(Metadata metadata, Optional<OrientationChange> orientation) throws ImageIOException {
        Optional extent = OptionalUtilities.orFlatSupplier((CheckedSupplier[])new CheckedSupplier[]{() -> FromExifIfPossible.readExif(metadata), () -> FromExifIfPossible.readOther(metadata)});
        if (extent.isPresent()) {
            if (orientation.isPresent()) {
                return Optional.of(orientation.get().extent((Extent)extent.get()));
            }
            return extent;
        }
        return Optional.empty();
    }

    private static Optional<Extent> readExif(Metadata metadata) throws ImageIOException {
        return ReadMetadataUtilities.readFromWidthHeightTags((Metadata)metadata, ExifIFD0Directory.class, (int)256, (int)257);
    }

    private static Optional<Extent> readOther(Metadata metadata) throws ImageIOException {
        return ReadMetadataUtilities.readFromWidthHeightTags((Metadata)metadata, JpegDirectory.class, (int)3, (int)1);
    }

    private FromExifIfPossible() {
    }
}

