/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.metadata.header;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.png.PngDirectory;
import java.util.Optional;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.core.stack.ImageFileAttributes;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.io.bioformats.metadata.ReadMetadataUtilities;
import org.anchoranalysis.plugin.io.bean.metadata.header.HeaderFormat;
import org.anchoranalysis.plugin.io.bean.metadata.header.MetadataFactory;
import org.anchoranalysis.spatial.box.Extent;

public class PNG
extends HeaderFormat {
    @Override
    protected ImageFileFormat format() {
        return ImageFileFormat.PNG;
    }

    @Override
    protected Optional<ImageMetadata> populateFromMetadata(Metadata metadata, ImageFileAttributes attributes) throws ImageIOException {
        Optional directory = ReadMetadataUtilities.findDirectoryWithName((Metadata)metadata, PngDirectory.class, (String)"PNG-IHDR");
        if (!directory.isPresent()) {
            return Optional.empty();
        }
        Optional extent = ReadMetadataUtilities.readFromWidthHeightTags((Directory)((Directory)directory.get()), (int)1, (int)2);
        if (!extent.isPresent()) {
            return Optional.empty();
        }
        Optional<Integer> numberChannels = PNG.numberOfChannels((Directory)directory.get());
        if (!numberChannels.isPresent()) {
            return Optional.empty();
        }
        Optional bitDepth = ReadMetadataUtilities.readInt((Directory)((Directory)directory.get()), (int)3);
        if (!bitDepth.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(MetadataFactory.createMetadata((Extent)extent.get(), numberChannels.get(), (Integer)bitDepth.get(), attributes));
    }

    private static Optional<Integer> numberOfChannels(Directory directory) throws ImageIOException {
        Optional colorType = ReadMetadataUtilities.readInt((Directory)directory, (int)4);
        if (!colorType.isPresent()) {
            return Optional.empty();
        }
        switch ((Integer)colorType.get()) {
            case 0: {
                return Optional.of(1);
            }
            case 2: 
            case 3: {
                return Optional.of(3);
            }
            case 4: {
                return Optional.of(2);
            }
            case 6: {
                return Optional.of(4);
            }
        }
        throw new ImageIOException("Unrecognised color-type in PNG header: " + colorType.get());
    }
}

