/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.metadata.reader;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.ImageMetadataReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.plugin.io.bean.metadata.header.HeaderFormat;
import org.anchoranalysis.plugin.io.bean.metadata.header.JPEG;

public class InferFromHeader
extends ImageMetadataReader {
    @BeanField
    private ImageMetadataReader fallback;
    @BeanField
    private List<HeaderFormat> formats = InferFromHeader.createDefaultFormats();

    public ImageMetadata openFile(Path path, StackReader defaultStackReader, OperationContext context) throws ImageIOException {
        return (ImageMetadata)OptionalUtilities.orElseGet(this.attemptToPopulateFromMetadata(path, context.getLogger().errorReporter()), () -> this.useFallbackReader(path, defaultStackReader, context));
    }

    private Optional<ImageMetadata> attemptToPopulateFromMetadata(Path path, ErrorReporter errorReporter) throws ImageIOException {
        for (HeaderFormat format : this.formats) {
            try {
                Optional<ImageMetadata> metadata = format.populateFrom(path);
                if (!metadata.isPresent()) continue;
                return Optional.of(metadata.get());
            }
            catch (Exception e) {
                errorReporter.recordError(InferFromHeader.class, "Switching to fallback, as cannot infer metadata from the header due to the following exception.", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private ImageMetadata useFallbackReader(Path path, StackReader defaultStackReader, OperationContext context) throws ImageIOException {
        return this.fallback.openFile(path, defaultStackReader, context);
    }

    private static List<HeaderFormat> createDefaultFormats() {
        return Arrays.asList(new HeaderFormat[]{new JPEG()});
    }

    public InferFromHeader() {
    }

    public InferFromHeader(ImageMetadataReader fallback, List<HeaderFormat> formats) {
        this.fallback = fallback;
        this.formats = formats;
    }

    public ImageMetadataReader getFallback() {
        return this.fallback;
    }

    public void setFallback(ImageMetadataReader fallback) {
        this.fallback = fallback;
    }

    public List<HeaderFormat> getFormats() {
        return this.formats;
    }

    public void setFormats(List<HeaderFormat> formats) {
        this.formats = formats;
    }
}

