/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.path.derive;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.bean.path.Identity;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.plugin.io.bean.path.derive.PathTwoParts;

public class CollapseFileName
extends DerivePath {
    @BeanField
    private DerivePath derivePath = new Identity();
    @BeanField
    private boolean keepExtension = false;

    public Path deriveFrom(Path source, boolean debugMode) throws DerivePathException {
        Path path = this.derivePath.deriveFrom(source, debugMode);
        try {
            return this.createDerivedPath(path);
        }
        catch (CreateException e) {
            throw new DerivePathException((Throwable)e);
        }
    }

    private Path createDerivedPath(Path source) throws CreateException {
        PathTwoParts pathParts = new PathTwoParts(source);
        if (this.keepExtension) {
            Optional extension = ExtensionUtilities.extractExtension((Path)pathParts.getSecond());
            return ExtensionUtilities.appendExtension((Path)pathParts.getFirst(), (Optional)extension);
        }
        return pathParts.getFirst();
    }

    public DerivePath getDerivePath() {
        return this.derivePath;
    }

    public void setDerivePath(DerivePath derivePath) {
        this.derivePath = derivePath;
    }

    public boolean isKeepExtension() {
        return this.keepExtension;
    }

    public void setKeepExtension(boolean keepExtension) {
        this.keepExtension = keepExtension;
    }
}

