/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.path.derive;

import java.nio.file.Path;
import org.anchoranalysis.core.exception.CreateException;

class PathTwoParts {
    private Path first;
    private Path second;

    public PathTwoParts(Path path) throws CreateException {
        PathTwoParts.checkPathHasParent(path);
        if (path.endsWith("/")) {
            this.first = path;
            this.second = null;
        } else {
            this.first = path.getParent();
            this.second = path.getFileName();
        }
    }

    public void removeLastDirectory() {
        this.first = this.first.getParent();
    }

    public void moveLastDirectoryToRest() {
        Path name = this.first.getFileName();
        this.second = name.resolve(this.second);
        this.first = this.first.getParent();
    }

    public Path combine() {
        return this.first.resolve(this.second);
    }

    private static void checkPathHasParent(Path path) throws CreateException {
        if (path.getParent() == null) {
            throw new CreateException(String.format("No parent exists for %s", path));
        }
    }

    public Path getFirst() {
        return this.first;
    }

    public Path getSecond() {
        return this.second;
    }
}

