/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.path.derive;

import java.nio.file.Path;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.plugin.io.bean.path.derive.PathTwoParts;

public class RemoveTrailingDirectory
extends DerivePath {
    @BeanField
    private DerivePath derivePath;
    @BeanField
    private int trimTrailingDirectory = 0;
    @BeanField
    private int skipFirstTrim = 0;

    public Path deriveFrom(Path source, boolean debugMode) throws DerivePathException {
        Path path = this.derivePath.deriveFrom(source, debugMode);
        if (this.trimTrailingDirectory > 0) {
            return this.removeNTrailingDirs(path, this.trimTrailingDirectory, this.skipFirstTrim);
        }
        return path;
    }

    private Path removeNTrailingDirs(Path path, int n, int skipFirstTrim) throws DerivePathException {
        try {
            int i;
            PathTwoParts pathDir = new PathTwoParts(path);
            for (i = 0; i < skipFirstTrim; ++i) {
                pathDir.moveLastDirectoryToRest();
            }
            for (i = 0; i < n; ++i) {
                pathDir.removeLastDirectory();
            }
            return pathDir.combine();
        }
        catch (CreateException e) {
            throw new DerivePathException((Throwable)e);
        }
    }

    public DerivePath getDerivePath() {
        return this.derivePath;
    }

    public void setDerivePath(DerivePath derivePath) {
        this.derivePath = derivePath;
    }

    public int getTrimTrailingDirectory() {
        return this.trimTrailingDirectory;
    }

    public void setTrimTrailingDirectory(int trimTrailingDirectory) {
        this.trimTrailingDirectory = trimTrailingDirectory;
    }

    public int getSkipFirstTrim() {
        return this.skipFirstTrim;
    }

    public void setSkipFirstTrim(int skipFirstTrim) {
        this.skipFirstTrim = skipFirstTrim;
    }
}

