/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.path.derive;

import java.nio.file.Path;
import java.util.logging.Logger;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.system.path.PathDifferenceException;
import org.anchoranalysis.core.system.path.ResolvePathAbsolute;
import org.anchoranalysis.core.system.path.SplitPath;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.plugin.io.input.path.RootPathMap;

public class Rooted
extends DerivePath {
    @BeanField
    private DerivePath item;
    @BeanField
    private String rootName;
    @BeanField
    private boolean suppressRootOut = false;
    @BeanField
    private boolean logPath = false;
    private Logger logger = Logger.getLogger(Rooted.class.getName());

    public Path deriveFrom(Path source, boolean debugMode) throws DerivePathException {
        try {
            SplitPath pathInWithoutRoot = RootPathMap.instance().split(source, this.rootName, debugMode);
            Path pathOut = this.determinePathOut(pathInWithoutRoot, debugMode);
            if (this.logPath) {
                this.logger.info(() -> String.format("pathIn=%s", source));
                this.logger.info(() -> String.format("pathOut=%s", pathOut));
            }
            return pathOut;
        }
        catch (PathDifferenceException e) {
            throw new DerivePathException((Throwable)e);
        }
    }

    private Path determinePathOut(SplitPath pathInWithoutRoot, boolean debugMode) throws DerivePathException {
        Path pathOut = this.item.deriveFrom(pathInWithoutRoot.getRemainder(), debugMode);
        if (this.suppressRootOut) {
            Path path = (Path)this.getLocalPath().orElseThrow(() -> new DerivePathException("No local path is associated with the bean."));
            pathOut = ResolvePathAbsolute.resolve((Path)path, (Path)pathOut);
        } else {
            pathOut = pathInWithoutRoot.getRoot().resolve(pathOut);
        }
        return pathOut;
    }

    public DerivePath getItem() {
        return this.item;
    }

    public void setItem(DerivePath item) {
        this.item = item;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public boolean isSuppressRootOut() {
        return this.suppressRootOut;
    }

    public void setSuppressRootOut(boolean suppressRootOut) {
        this.suppressRootOut = suppressRootOut;
    }

    public boolean isLogPath() {
        return this.logPath;
    }

    public void setLogPath(boolean logPath) {
        this.logPath = logPath;
    }
}

