/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.reader;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.plugin.io.bean.stack.reader.OpenedRasterAlterDimensions;

public class ImposeResolution
extends StackReader {
    @BeanField
    private StackReader stackReader;
    @BeanField
    private double width;
    @BeanField
    private double height;
    @BeanField
    private double depth = 0.0;
    @BeanField
    private boolean keepZ = false;

    public OpenedImageFile openFile(Path path, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        return new OpenedRasterAlterDimensions(this.stackReader.openFile(path, executionTimeRecorder), existing -> Optional.of(this.resolutionToAssign(existing)));
    }

    private Resolution resolutionToAssign(Optional<Resolution> existing) throws ImageIOException {
        double z = this.keepZ && existing.isPresent() ? existing.get().z() : this.depth;
        try {
            return new Resolution(this.width, this.height, z);
        }
        catch (CreateException e) {
            throw new ImageIOException("An error occurred assigning an image-resolution.", (Throwable)e);
        }
    }

    public StackReader getStackReader() {
        return this.stackReader;
    }

    public void setStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public boolean isKeepZ() {
        return this.keepZ;
    }

    public void setKeepZ(boolean keepZ) {
        this.keepZ = keepZ;
    }
}

