/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.reader;

import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.plugin.io.bean.file.group.parser.FilePathParser;
import org.anchoranalysis.plugin.io.multifile.FileDetails;
import org.anchoranalysis.plugin.io.multifile.OpenedMultiFile;
import org.anchoranalysis.plugin.io.multifile.ParsedFilePathBag;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class MultiFileReader
extends StackReader {
    @BeanField
    private FilePathParser filePathParser;
    @BeanField
    @DefaultInstance
    private StackReader stackReader;
    @BeanField
    private boolean recurseSubfolders = false;
    @BeanField
    private int navigateHigherDirectories = 0;
    @BeanField
    @AllowEmpty
    private String regExFile = "";
    @BeanField
    @AllowEmpty
    private String regExDirectory = "";

    public OpenedImageFile openFile(Path filePath, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        Iterator fileIterator = FileUtils.iterateFiles((File)this.folderFromFile(filePath), (IOFileFilter)MultiFileReader.maybeRegExFilter(this.regExFile), (IOFileFilter)this.recurseFilter());
        ParsedFilePathBag bag = new ParsedFilePathBag();
        while (fileIterator.hasNext()) {
            Optional<FileDetails> details = this.filePathParser.parsePath(((File)fileIterator.next()).toPath());
            if (!details.isPresent()) continue;
            bag.add(details.get());
        }
        return new OpenedMultiFile(this.stackReader, bag, executionTimeRecorder);
    }

    private File folderFromFile(Path filePath) {
        File dir = filePath.toFile();
        if (!filePath.toFile().isDirectory()) {
            dir = dir.getParentFile();
        }
        for (int i = 0; i < this.navigateHigherDirectories; ++i) {
            dir = dir.getParentFile();
        }
        return dir;
    }

    private IOFileFilter recurseFilter() {
        return this.recurseSubfolders ? MultiFileReader.maybeRegExFilter(this.regExDirectory) : null;
    }

    private static IOFileFilter maybeRegExFilter(String regEx) {
        if (!regEx.isEmpty()) {
            return new RegexFileFilter(regEx);
        }
        return TrueFileFilter.INSTANCE;
    }

    public FilePathParser getFilePathParser() {
        return this.filePathParser;
    }

    public void setFilePathParser(FilePathParser filePathParser) {
        this.filePathParser = filePathParser;
    }

    public StackReader getStackReader() {
        return this.stackReader;
    }

    public void setStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    public boolean isRecurseSubfolders() {
        return this.recurseSubfolders;
    }

    public void setRecurseSubfolders(boolean recurseSubfolders) {
        this.recurseSubfolders = recurseSubfolders;
    }

    public int getNavigateHigherDirectories() {
        return this.navigateHigherDirectories;
    }

    public void setNavigateHigherDirectories(int navigateHigherDirectories) {
        this.navigateHigherDirectories = navigateHigherDirectories;
    }

    public String getRegExFile() {
        return this.regExFile;
    }

    public void setRegExFile(String regExFile) {
        this.regExFile = regExFile;
    }

    public String getRegExDirectory() {
        return this.regExDirectory;
    }

    public void setRegExDirectory(String regExDirectory) {
        this.regExDirectory = regExDirectory;
    }
}

