/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.ImagePyramidMetadata;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.input.ImageTimestampsAttributes;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.image.io.stack.time.TimeSeries;

class OpenedFlattenAsChannel
implements OpenedImageFile {
    private final OpenedImageFile delegate;

    public int numberSeries() {
        return 1;
    }

    public TimeSeries open(int seriesIndex, Logger logger) throws ImageIOException {
        try {
            Stack out = new Stack();
            int numberSeries = this.delegate.numberSeries();
            for (int i = 0; i < numberSeries; ++i) {
                TimeSeries series = this.delegate.open(seriesIndex, logger);
                OpenedFlattenAsChannel.addStack(this.extractStacksAndVerify(series, logger), out);
            }
            return new TimeSeries(out);
        }
        catch (IncorrectImageSizeException e) {
            throw new ImageIOException("An incorrect image size was encountered when opening an image", (Throwable)e);
        }
    }

    public Optional<List<String>> channelNames(Logger logger) {
        return Optional.empty();
    }

    public int bitDepth(Logger logger) throws ImageIOException {
        return this.delegate.bitDepth(logger);
    }

    public int numberChannels(Logger logger) throws ImageIOException {
        return this.delegate.numberChannels(logger) * this.delegate.numberSeries() * this.delegate.numberFrames(logger);
    }

    public int numberFrames(Logger logger) {
        return 1;
    }

    public boolean isRGB(Logger logger) throws ImageIOException {
        return false;
    }

    public void close() throws ImageIOException {
        this.delegate.close();
    }

    public Dimensions dimensionsForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        return this.delegate.dimensionsForSeries(seriesIndex, logger);
    }

    public ImageTimestampsAttributes timestamps() throws ImageIOException {
        return this.delegate.timestamps();
    }

    public Optional<ImagePyramidMetadata> pyramid() throws ImageIOException {
        return this.delegate.pyramid();
    }

    private List<Stack> extractStacksAndVerify(TimeSeries sequence, Logger logger) throws ImageIOException {
        int expectedNumberChannels = this.delegate.numberChannels(logger);
        int expectedNumberFrames = this.delegate.numberFrames(logger);
        if (sequence.size() != expectedNumberFrames) {
            throw new ImageIOException(String.format("This bean expects %d frames to always be returned from the stackReader to only return images with a single time-frame, but it returned an image with %d frames", expectedNumberFrames, sequence.size()));
        }
        ArrayList<Stack> out = new ArrayList<Stack>();
        for (int i = 0; i < sequence.size(); ++i) {
            Stack stack = sequence.getFrame(i);
            if (stack.getNumberChannels() != expectedNumberChannels) {
                throw new ImageIOException(String.format("This bean expects %d channels to always be returned from the stackReader to only return images with a single time-frame, but it returned an image with %d channels", expectedNumberChannels, stack.getNumberChannels()));
            }
            out.add(stack);
        }
        return out;
    }

    private static void addStack(List<Stack> source, Stack destination) throws IncorrectImageSizeException {
        for (Stack stack : source) {
            OpenedFlattenAsChannel.addStack(stack, destination);
        }
    }

    private static void addStack(Stack source, Stack destination) throws IncorrectImageSizeException {
        for (Channel channel : source) {
            destination.addChannel(channel);
        }
    }

    public OpenedFlattenAsChannel(OpenedImageFile delegate) {
        this.delegate = delegate;
    }
}

