/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.reader;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.stack.ImagePyramidMetadata;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.input.ImageTimestampsAttributes;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.image.io.stack.time.TimeSeries;

class OpenedRasterAlterDimensions
implements OpenedImageFile {
    private OpenedImageFile delegate;
    private ConsiderUpdatedImageResolution processor;

    public int numberSeries() {
        return this.delegate.numberSeries();
    }

    public TimeSeries open(int seriesIndex, Logger logger) throws ImageIOException {
        TimeSeries series = this.delegate.open(seriesIndex, logger);
        for (Stack stack : series) {
            Optional<Resolution> resolution = this.processor.maybeUpdatedResolution(stack.resolution());
            resolution.ifPresent(arg_0 -> ((Stack)stack).assignResolution(arg_0));
        }
        return series;
    }

    public Optional<List<String>> channelNames(Logger logger) throws ImageIOException {
        return this.delegate.channelNames(logger);
    }

    public int numberChannels(Logger logger) throws ImageIOException {
        return this.delegate.numberChannels(logger);
    }

    public Dimensions dimensionsForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        Dimensions dimensions = this.delegate.dimensionsForSeries(seriesIndex, logger);
        Optional<Resolution> resolution = this.processor.maybeUpdatedResolution(dimensions.resolution());
        if (resolution.isPresent()) {
            return dimensions.duplicateChangeResolution(resolution);
        }
        return dimensions;
    }

    public int numberFrames(Logger logger) throws ImageIOException {
        return this.delegate.numberFrames(logger);
    }

    public boolean isRGB(Logger logger) throws ImageIOException {
        return this.delegate.isRGB(logger);
    }

    public int bitDepth(Logger logger) throws ImageIOException {
        return this.delegate.bitDepth(logger);
    }

    public ImageTimestampsAttributes timestamps() throws ImageIOException {
        return this.delegate.timestamps();
    }

    public Optional<ImagePyramidMetadata> pyramid() throws ImageIOException {
        return this.delegate.pyramid();
    }

    public void close() throws ImageIOException {
        this.delegate.close();
    }

    public OpenedRasterAlterDimensions(OpenedImageFile delegate, ConsiderUpdatedImageResolution processor) {
        this.delegate = delegate;
        this.processor = processor;
    }

    @FunctionalInterface
    public static interface ConsiderUpdatedImageResolution {
        public Optional<Resolution> maybeUpdatedResolution(Optional<Resolution> var1) throws ImageIOException;
    }
}

