/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.reader;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.shared.relation.threshold.RelationToThreshold;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.math.relation.DoubleBiPredicate;
import org.anchoranalysis.plugin.io.bean.stack.reader.OpenedRasterAlterDimensions;

public class RejectIfConditionXYResolution
extends StackReader {
    @BeanField
    @DefaultInstance
    private StackReader stackReader;
    @BeanField
    private RelationToThreshold relation;

    public OpenedImageFile openFile(Path path, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        OpenedImageFile openedFile = this.stackReader.openFile(path, executionTimeRecorder);
        return new OpenedRasterAlterDimensions(openedFile, new MaybeRejectProcessor(this.relation.relation(), this.relation.threshold()));
    }

    public StackReader getStackReader() {
        return this.stackReader;
    }

    public void setStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    public RelationToThreshold getRelation() {
        return this.relation;
    }

    public void setRelation(RelationToThreshold relation) {
        this.relation = relation;
    }

    private static class MaybeRejectProcessor
    implements OpenedRasterAlterDimensions.ConsiderUpdatedImageResolution {
        private static final double DELTA_RESOLUTION = 1.0E-15;
        private DoubleBiPredicate relation;
        private double value;

        @Override
        public Optional<Resolution> maybeUpdatedResolution(Optional<Resolution> resolution) throws ImageIOException {
            if (!resolution.isPresent()) {
                throw new ImageIOException("No image-resolution is present, so cannot perform this check.");
            }
            if (!MaybeRejectProcessor.hasEqualXAndYResolution(resolution.get())) {
                throw new ImageIOException("X and Y pixel-sizes are different. They must be equal");
            }
            if (this.relation.test(resolution.get().x(), this.value)) {
                throw new ImageIOException("XY-resolution fufills condition, and is thus rejected");
            }
            return Optional.empty();
        }

        private static boolean hasEqualXAndYResolution(Resolution resolution) {
            return Math.abs(resolution.x() - resolution.y()) < 1.0E-15;
        }

        public MaybeRejectProcessor(DoubleBiPredicate relation, double value) {
            this.relation = relation;
            this.value = value;
        }
    }
}

