/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.writer;

import java.util.function.Supplier;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.image.io.stack.output.StackRGBState;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;
import org.anchoranalysis.plugin.io.bean.stack.writer.StackWriterDelegateBase;

public class BranchChannels
extends StackWriterDelegateBase {
    @BeanField
    private StackWriter writer;
    @BeanField
    @OptionalBean
    private StackWriter whenNotEightBit;
    @BeanField
    @OptionalBean
    private StackWriter whenRGB;
    @BeanField
    @OptionalBean
    private StackWriter whenRGBAlpha;
    @BeanField
    @OptionalBean
    private StackWriter whenSingleChannel;
    @BeanField
    @OptionalBean
    private StackWriter whenThreeChannels;
    @BeanField
    @OptionalBean
    private StackWriter whenBinaryChannel;

    @Override
    protected StackWriter selectDelegate(StackWriteOptions writeOptions) {
        StackWriteAttributes attributes = writeOptions.getAttributes();
        if (!attributes.isEightBitChannels()) {
            return this.writerOrDefault(this.whenNotEightBit);
        }
        if (attributes.getRgb() == StackRGBState.RGB_WITHOUT_ALPHA) {
            return this.writerOrDefault(this.whenRGB);
        }
        if (attributes.getRgb() == StackRGBState.RGB_WITH_ALPHA) {
            return this.writerOrDefault(this.whenRGBAlpha);
        }
        if (attributes.isThreeChannels()) {
            return this.writerOrDefault(this.whenThreeChannels);
        }
        if (attributes.isSingleChannel()) {
            return this.singleChannel(writeOptions);
        }
        return this.writer;
    }

    private StackWriter singleChannel(StackWriteOptions writeOptions) {
        if (writeOptions.getAttributes().isBinary()) {
            return BranchChannels.writerOrFallback(this.whenBinaryChannel, this::singleNonBinaryChannel);
        }
        return this.singleNonBinaryChannel();
    }

    private StackWriter singleNonBinaryChannel() {
        return this.writerOrDefault(this.whenSingleChannel);
    }

    private StackWriter writerOrDefault(StackWriter writerMaybeNull) {
        return BranchChannels.writerOrFallback(writerMaybeNull, () -> this.writer);
    }

    private static StackWriter writerOrFallback(StackWriter writerMaybeNull, Supplier<StackWriter> writerFallback) {
        if (writerMaybeNull != null) {
            return writerMaybeNull;
        }
        return writerFallback.get();
    }

    public StackWriter getWriter() {
        return this.writer;
    }

    public void setWriter(StackWriter writer) {
        this.writer = writer;
    }

    public StackWriter getWhenNotEightBit() {
        return this.whenNotEightBit;
    }

    public void setWhenNotEightBit(StackWriter whenNotEightBit) {
        this.whenNotEightBit = whenNotEightBit;
    }

    public StackWriter getWhenRGB() {
        return this.whenRGB;
    }

    public void setWhenRGB(StackWriter whenRGB) {
        this.whenRGB = whenRGB;
    }

    public StackWriter getWhenRGBAlpha() {
        return this.whenRGBAlpha;
    }

    public void setWhenRGBAlpha(StackWriter whenRGBAlpha) {
        this.whenRGBAlpha = whenRGBAlpha;
    }

    public StackWriter getWhenSingleChannel() {
        return this.whenSingleChannel;
    }

    public void setWhenSingleChannel(StackWriter whenSingleChannel) {
        this.whenSingleChannel = whenSingleChannel;
    }

    public StackWriter getWhenThreeChannels() {
        return this.whenThreeChannels;
    }

    public void setWhenThreeChannels(StackWriter whenThreeChannels) {
        this.whenThreeChannels = whenThreeChannels;
    }

    public StackWriter getWhenBinaryChannel() {
        return this.whenBinaryChannel;
    }

    public void setWhenBinaryChannel(StackWriter whenBinaryChannel) {
        this.whenBinaryChannel = whenBinaryChannel;
    }
}

