/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.summarizer.input;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.value.StringUtilities;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.plugin.io.bean.summarizer.input.SummarizerInputFromManager;

public class ExtractIdentifierAndPath<T extends InputFromManager>
extends SummarizerInputFromManager<T, String> {
    @BeanField
    private int maxPathWidth = 40;

    @Override
    protected Optional<String> extractFrom(T input) {
        String identifier = input.identifier();
        String path = input.pathForBinding().map(Path::toString).orElse("<no identifier>");
        return Optional.of(String.format(this.formatString(path.length()), this.maybePadPath(path), identifier));
    }

    @Override
    public boolean requiresImageMetadata() {
        return false;
    }

    private String formatString(int identifierWidth) {
        if (identifierWidth <= this.maxPathWidth) {
            return "%s -> %s";
        }
        return "%s%n   -> %s";
    }

    private String maybePadPath(String identifier) {
        if (identifier.length() <= this.maxPathWidth) {
            return StringUtilities.rightPad((String)identifier, (int)this.maxPathWidth);
        }
        return identifier;
    }

    public int getMaxPathWidth() {
        return this.maxPathWidth;
    }

    public void setMaxPathWidth(int maxPathWidth) {
        this.maxPathWidth = maxPathWidth;
    }
}

