/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.summarizer.path;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.plugin.io.bean.summarizer.path.SummarizerPath;
import org.anchoranalysis.plugin.io.shared.FrequencyMap;

public class ExtensionCount
extends SummarizerPath {
    private static final String NO_EXTENSION = "NO_EXTENSION";
    private FrequencyMap<String> map = new FrequencyMap();

    @Override
    public void add(Path fullFilePath) {
        Optional extension = ExtensionUtilities.extractExtension((String)fullFilePath.toString());
        this.map.incrementCount(ExtensionCount.tidyExtension(extension));
    }

    @Override
    public String describe() {
        return this.map.describe("extension");
    }

    private static String tidyExtension(Optional<String> extension) {
        if (extension.isPresent()) {
            return extension.get().toLowerCase();
        }
        return NO_EXTENSION;
    }
}

