/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.summarizer.path;

import com.owenfeehan.pathpatternfinder.PathPatternFinder;
import com.owenfeehan.pathpatternfinder.Pattern;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.plugin.io.bean.summarizer.path.SummarizerPath;
import org.apache.commons.io.IOCase;

public class FilePathPattern
extends SummarizerPath {
    private boolean ignoreHidden = true;
    private boolean ignoreCase = false;
    private boolean removeExtension = true;
    private List<Path> list = new ArrayList<Path>();

    public FilePathPattern(String ... paths) throws OperationFailedException {
        CheckedStream.forEach(Arrays.stream(paths), OperationFailedException.class, this::addElement);
    }

    @Override
    public synchronized void add(Path element) throws OperationFailedException {
        try {
            if (this.acceptPath(element)) {
                this.addPath(element);
            }
        }
        catch (IOException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public synchronized String describe() throws OperationFailedException {
        if (this.list.isEmpty()) {
            throw new OperationFailedException("There are no paths to summarize");
        }
        if (this.list.size() == 1) {
            return this.list.get(0).toString();
        }
        Pattern pattern = PathPatternFinder.findPatternPaths(this.list, (IOCase)this.selectIOCase(), (boolean)true);
        return pattern.describeDetailed();
    }

    private void addElement(String element) {
        this.addPath(Paths.get(element, new String[0]));
    }

    private void addPath(Path path) {
        if (this.removeExtension) {
            this.list.add(ExtensionUtilities.removeExtension((Path)path));
        } else {
            this.list.add(path);
        }
    }

    private boolean acceptPath(Path path) throws IOException {
        return !path.toFile().exists() || !this.ignoreHidden || !Files.isHidden(path);
    }

    private IOCase selectIOCase() {
        return this.ignoreCase ? IOCase.INSENSITIVE : IOCase.SYSTEM;
    }

    public FilePathPattern() {
    }

    public boolean isIgnoreHidden() {
        return this.ignoreHidden;
    }

    public void setIgnoreHidden(boolean ignoreHidden) {
        this.ignoreHidden = ignoreHidden;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isRemoveExtension() {
        return this.removeExtension;
    }

    public void setRemoveExtension(boolean removeExtension) {
        this.removeExtension = removeExtension;
    }
}

