/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.summarizer.path;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.math.arithmetic.RunningSum;
import org.anchoranalysis.plugin.io.bean.summarizer.path.SummarizerPath;
import org.apache.commons.io.FileUtils;

public class FileSizeStatistics
extends SummarizerPath {
    private RunningSum runningSum = new RunningSum();
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Path filePath) throws OperationFailedException {
        try {
            long size = Files.size(filePath);
            FileSizeStatistics fileSizeStatistics = this;
            synchronized (fileSizeStatistics) {
                this.runningSum.increment((double)size);
                if (size < this.min) {
                    this.min = size;
                }
                if (size > this.max) {
                    this.max = size;
                }
            }
        }
        catch (IOException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public synchronized String describe() throws OperationFailedException {
        if (this.runningSum.getCount() == 0L) {
            throw new OperationFailedException("There are no paths to summarize");
        }
        if (this.runningSum.getCount() == 1L) {
            return String.format("File-size is %s.", FileSizeStatistics.humanReadableSize(this.min));
        }
        if (this.min == this.max) {
            return String.format("All inputs have identical size of %s.", FileSizeStatistics.humanReadableSize(this.min));
        }
        return String.format("file-sizes range across [%s to %s] with an average of %s.", FileSizeStatistics.humanReadableSize(this.min), FileSizeStatistics.humanReadableSize(this.max), FileSizeStatistics.humanReadableSize((long)this.runningSum.mean()));
    }

    private static String humanReadableSize(long fileSizeBytes) {
        return FileUtils.byteCountToDisplaySize((long)fileSizeBytes);
    }
}

