/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.task;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.file.FileWithDirectoryInput;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.math.arithmetic.Counter;
import org.anchoranalysis.plugin.io.bean.file.copy.method.Bytewise;
import org.anchoranalysis.plugin.io.bean.file.copy.method.CopyFilesMethod;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.CopyFilesNaming;
import org.anchoranalysis.plugin.io.input.path.CopyContext;
import org.anchoranalysis.plugin.io.shared.RecordingCounter;

public class CopyFiles<T>
extends Task<FileWithDirectoryInput, RecordingCounter<T>> {
    private static final String OUTPUT_COPY = "copy";
    @BeanField
    private CopyFilesMethod method = new Bytewise();
    @BeanField
    private CopyFilesNaming<T> naming;

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(FileWithDirectoryInput.class);
    }

    public RecordingCounter<T> beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<FileWithDirectoryInput> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            T namingSharedState = this.naming.beforeCopying(parameters.getOutputter().getOutputDirectory(), inputs);
            return new RecordingCounter<T>(new Counter(), outputter, namingSharedState);
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public void doJobOnInput(InputBound<FileWithDirectoryInput, RecordingCounter<T>> input) throws JobExecutionException {
        try {
            this.copyFile(((FileWithDirectoryInput)input.getInput()).getDirectory(), input.getContextExperiment().getOutputter(), ((FileWithDirectoryInput)input.getInput()).getFile(), input.getContextJob().getOutputter().getPrefix(), (RecordingCounter)input.getSharedState());
        }
        catch (OperationFailedException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    public void afterAllJobsAreExecuted(RecordingCounter<T> sharedState, InputOutputContext context) throws ExperimentExecutionException {
        sharedState.closeLogger();
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_COPY});
    }

    private void copyFile(Path source, Outputter outputter, File file, DirectoryWithPrefix outputTarget, RecordingCounter<T> recordingCounter) throws OperationFailedException {
        Path destinationDirectory = outputter.getOutputDirectory();
        boolean copyEnabled = outputter.outputsEnabled().isOutputEnabled(OUTPUT_COPY);
        try {
            int index = recordingCounter.incrementCounter();
            CopyContext<T> context = new CopyContext<T>(source, destinationDirectory, recordingCounter.getNamingSharedState());
            Optional<Path> destinationFile = this.naming.destinationPath(file, outputTarget, index, context);
            recordingCounter.recordCopiedOutput(file.toPath().toAbsolutePath().normalize(), destinationFile, index);
            if (destinationFile.isPresent() && copyEnabled) {
                this.method.makeCopy(file.toPath(), destinationFile.get());
            }
        }
        catch (CreateException | OutputWriteFailedException e) {
            throw new OperationFailedException(e);
        }
    }

    public CopyFilesMethod getMethod() {
        return this.method;
    }

    public void setMethod(CopyFilesMethod method) {
        this.method = method;
    }

    public CopyFilesNaming<T> getNaming() {
        return this.naming;
    }

    public void setNaming(CopyFilesNaming<T> naming) {
        this.naming = naming;
    }
}

