/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.task;

import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.value.TypedValue;

class TypedValueUtilities {
    public static List<String> createArrayFromList(List<String[]> list, int index) throws OperationFailedException {
        ArrayList<String> out = new ArrayList<String>(list.size());
        for (String[] s : list) {
            out.add(TypedValueUtilities.removeQuotes(s[index]));
        }
        return out;
    }

    public static List<TypedValue> createTypedArrayFromList(List<String[]> list, int index) throws OperationFailedException {
        ArrayList<TypedValue> out = new ArrayList<TypedValue>(list.size());
        for (String[] s : list) {
            TypedValueUtilities.addGuessType(out, s[index]);
        }
        return out;
    }

    public static List<String> listFromArray(String[] arr) throws OperationFailedException {
        ArrayList<String> out = new ArrayList<String>(arr.length);
        for (String s : arr) {
            out.add(TypedValueUtilities.removeQuotes(s));
        }
        return out;
    }

    public static List<TypedValue> typeArray(String[] arr) throws OperationFailedException {
        ArrayList<TypedValue> out = new ArrayList<TypedValue>(arr.length);
        for (String s : arr) {
            TypedValueUtilities.addGuessType(out, s);
        }
        return out;
    }

    private static String removeQuotes(String s) throws OperationFailedException {
        if (s.charAt(0) != '\"') {
            throw new OperationFailedException("Quote character at start is missing");
        }
        if (s.charAt(s.length() - 1) != '\"') {
            throw new OperationFailedException("Quote character at end is missing");
        }
        return s.substring(1, s.length() - 1);
    }

    private static void addGuessType(List<TypedValue> out, String s) throws OperationFailedException {
        if (s.charAt(0) == '\"') {
            out.add(new TypedValue(TypedValueUtilities.removeQuotes(s)));
        } else {
            out.add(new TypedValue(s, true));
        }
    }

    private TypedValueUtilities() {
    }
}

