/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.file.copy;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.ClusterIdentifier;

public class ClusterMembership {
    private final ClusterIdentifier clusterIdentifierIfAbsent;
    private Map<File, ClusterIdentifier> map = new HashMap<File, ClusterIdentifier>();

    public void associateFileWithCluster(File file, long timestamp, ClusterIdentifier clusterIdentifier) throws OperationFailedException {
        clusterIdentifier.addTimestamp(timestamp);
        if (this.map.putIfAbsent(file, clusterIdentifier) != null) {
            throw new OperationFailedException(String.format("The file is already associated with a cluster: %s", file));
        }
    }

    public ClusterIdentifier clusterFor(File file) {
        ClusterIdentifier mapping = this.map.get(file);
        if (mapping != null) {
            return mapping;
        }
        return this.clusterIdentifierIfAbsent;
    }

    public ClusterMembership(ClusterIdentifier clusterIdentifierIfAbsent) {
        this.clusterIdentifierIfAbsent = clusterIdentifierIfAbsent;
    }
}

