/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.input.filter;

import java.util.List;
import java.util.ListIterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.anchoranalysis.io.input.InputFromManager;

public class FilterDescriptiveNameEqualsContains {
    private String equals;
    private String contains;

    public <T extends InputFromManager> List<T> removeNonMatching(List<T> in) {
        if (!this.atLeastOneCondition()) {
            return in;
        }
        FilterDescriptiveNameEqualsContains.removeNonMatchingFrom(in, this::combinedPredicate);
        return in;
    }

    private static <T extends InputFromManager> void removeNonMatchingFrom(List<T> in, Predicate<String> predicate) {
        ListIterator<T> itr = in.listIterator();
        while (itr.hasNext()) {
            InputFromManager item = (InputFromManager)itr.next();
            if (predicate.test(item.identifier())) continue;
            itr.remove();
        }
    }

    private boolean atLeastOneCondition() {
        return !this.equals.isEmpty() || !this.contains.isEmpty();
    }

    private boolean combinedPredicate(String str) {
        return FilterDescriptiveNameEqualsContains.nonEmptyAndPredicate(str, this.equals, (ref, test) -> ref.equals(test)) && FilterDescriptiveNameEqualsContains.nonEmptyAndPredicate(str, this.contains, (ref, test) -> test.contains((CharSequence)ref));
    }

    private static boolean nonEmptyAndPredicate(String strToTest, String strReference, BiPredicate<String, String> func) {
        if (!strReference.isEmpty()) {
            return func.test(strReference, strToTest);
        }
        return true;
    }

    public FilterDescriptiveNameEqualsContains(String equals, String contains) {
        this.equals = equals;
        this.contains = contains;
    }
}

