/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.input.path;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.anchoranalysis.bean.shared.path.RootPath;
import org.anchoranalysis.bean.xml.BeanXMLLoader;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.system.path.PathDifferenceException;
import org.anchoranalysis.core.system.path.SplitPath;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

public class RootPathMap {
    private static RootPathMap instance = null;
    private MultiMap map = new MultiValueMap();

    public SplitPath split(Path pathIn, String rootName, boolean debugMode) throws PathDifferenceException {
        SplitPath out;
        try {
            RootPath firstRoot = this.findRoot(rootName, debugMode);
            out = firstRoot.split(pathIn);
        }
        catch (IllegalArgumentException e) {
            RootPath secondRoot = this.findRoot(rootName, false);
            if (debugMode) {
                out = secondRoot.split(pathIn);
            }
            throw e;
        }
        return out;
    }

    public static RootPathMap instance() {
        if (instance == null) {
            instance = new RootPathMap();
        }
        return instance;
    }

    public void addFromXmlFile(Path path) throws OperationFailedException {
        try {
            List listRootPaths = (List)BeanXMLLoader.loadBean((Path)path, (String)"bean");
            for (RootPath rp : listRootPaths) {
                assert (!this.contains(rp));
                this.add(rp);
            }
        }
        catch (BeanXMLException e) {
            throw new OperationFailedException(String.format("An error occurred loading bean XML from %s", path), (Throwable)e);
        }
    }

    private void add(RootPath item) throws OperationFailedException {
        if (this.contains(item)) {
            throw new OperationFailedException(String.format("Item %s already exists in multi-map", item));
        }
        this.map.put((Object)item.getName(), (Object)item);
    }

    public RootPath findRoot(String name, boolean debug) throws PathDifferenceException {
        Collection exst = (Collection)this.map.get((Object)name);
        if (exst == null || exst.isEmpty()) {
            throw new PathDifferenceException(String.format("Cannot find a root-path for '%s'", name));
        }
        assert (exst.size() < 3);
        if (exst.size() == 1) {
            return (RootPath)exst.iterator().next();
        }
        Iterator itr = exst.iterator();
        RootPath first = (RootPath)itr.next();
        if (first.isDebug() == debug) {
            return first;
        }
        return (RootPath)itr.next();
    }

    private boolean contains(RootPath item) {
        Collection exst = (Collection)this.map.get((Object)item.getName());
        if (exst == null) {
            return false;
        }
        for (RootPath other : exst) {
            if (!other.equals((Object)item)) continue;
            return true;
        }
        return false;
    }

    private RootPathMap() {
    }
}

