/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.multifile;

import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

class DataTypeChecker {
    private VoxelDataType dataType = null;

    DataTypeChecker() {
    }

    public void check(Stack stackForFile) throws ImageIOException {
        VoxelDataType stackDataType = stackForFile.getChannel(0).getVoxelDataType();
        if (!stackForFile.allChannelsHaveType(stackDataType)) {
            throw new ImageIOException("Channels have different data types");
        }
        this.checkSetDataType(stackDataType);
    }

    public VoxelDataType getDataType() {
        return this.dataType;
    }

    private void checkSetDataType(VoxelDataType stackDataType) throws ImageIOException {
        if (this.dataType == null) {
            this.dataType = stackDataType;
        } else if (!stackDataType.equals((Object)this.dataType)) {
            throw new ImageIOException(String.format("File has type %s. Other files have type %s", stackDataType, this.dataType));
        }
    }
}

