/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.multifile;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.plugin.io.multifile.FileDetails;
import org.anchoranalysis.plugin.io.multifile.IntegerRange;

public class ParsedFilePathBag
implements Iterable<FileDetails> {
    private List<FileDetails> list = new ArrayList<FileDetails>();

    public void add(FileDetails fileDetails) {
        this.list.add(fileDetails);
    }

    @Override
    public Iterator<FileDetails> iterator() {
        return this.list.iterator();
    }

    public Optional<IntegerRange> rangeChannelNum() {
        return this.range(FileDetails::getChannelIndex);
    }

    public Optional<IntegerRange> rangeSliceNum() {
        return this.range(FileDetails::getSliceIndex);
    }

    public Optional<IntegerRange> rangeTimeIndex() {
        return this.range(FileDetails::getTimeIndex);
    }

    private Optional<IntegerRange> range(Function<FileDetails, Optional<Integer>> func) {
        return OptionalUtilities.mapBoth(this.getMin(func), this.getMax(func), (min, max) -> new IntegerRange((int)min, (int)max));
    }

    private Optional<Integer> getMax(Function<FileDetails, Optional<Integer>> func) {
        return this.fileDetailsStream(func).max(Comparator.naturalOrder());
    }

    public Optional<Integer> getMin(Function<FileDetails, Optional<Integer>> func) {
        return this.fileDetailsStream(func).min(Comparator.naturalOrder());
    }

    private Stream<Integer> fileDetailsStream(Function<FileDetails, Optional<Integer>> func) {
        return this.list.stream().map(func).filter(Optional::isPresent).map(Optional::get);
    }

    public int size() {
        return this.list.size();
    }
}

