/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.multifile;

import java.util.Optional;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.plugin.io.multifile.IntegerRange;
import org.anchoranalysis.plugin.io.multifile.ParsedFilePathBag;
import org.anchoranalysis.spatial.box.Extent;

public class SizeExtents {
    private Optional<IntegerRange> rangeZ;
    private Optional<IntegerRange> rangeC;
    private Optional<IntegerRange> rangeT;
    private Integer sizeX = null;
    private Integer sizeY = null;

    public SizeExtents(ParsedFilePathBag fileBag) {
        this.rangeZ = fileBag.rangeSliceNum();
        this.rangeC = fileBag.rangeChannelNum();
        this.rangeT = fileBag.rangeTimeIndex();
    }

    public boolean hasNecessaryExtents() {
        return this.rangeC.isPresent() && this.rangeZ.isPresent() && this.rangeT.isPresent();
    }

    public void populateMissingFromArbitrarySlice(Stack stackArbitrarySlice) {
        this.sizeX = stackArbitrarySlice.dimensions().x();
        this.sizeY = stackArbitrarySlice.dimensions().y();
        if (!this.rangeC.isPresent()) {
            this.rangeC = Optional.of(new IntegerRange(stackArbitrarySlice.getNumberChannels()));
        }
        if (!this.rangeZ.isPresent()) {
            this.rangeZ = Optional.of(new IntegerRange(stackArbitrarySlice.dimensions().z()));
        }
        if (!this.rangeT.isPresent()) {
            this.rangeT = Optional.of(new IntegerRange(1));
        }
    }

    public Extent toExtent() {
        return new Extent(this.sizeX.intValue(), this.sizeY.intValue(), this.rangeZ.map(IntegerRange::getSize).orElse(1).intValue());
    }

    public IntegerRange getRangeZ() {
        return this.rangeZ.get();
    }

    public IntegerRange getRangeC() {
        return this.rangeC.get();
    }

    public IntegerRange getRangeT() {
        return this.rangeT.get();
    }

    public boolean rangeTPresent() {
        return this.rangeT.isPresent();
    }

    public boolean rangeCPresent() {
        return this.rangeC.isPresent();
    }
}

