/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.multifile;

import java.util.Iterator;
import java.util.TreeMap;
import org.anchoranalysis.plugin.io.multifile.SortedSetSlice;

public class SortedSetChannel
implements Comparable<SortedSetChannel>,
Iterable<SortedSetSlice> {
    private int channelNum;
    private TreeMap<Integer, SortedSetSlice> slices = new TreeMap();

    public int numSlices() {
        return this.slices.size();
    }

    public void add(int sliceNum, String filePath) {
        SortedSetSlice slice = this.slices.get(sliceNum);
        if (slice == null) {
            slice = new SortedSetSlice(filePath, sliceNum);
            this.slices.put(sliceNum, slice);
        } else {
            slice.setFilePath(filePath);
            assert (false);
        }
    }

    @Override
    public int compareTo(SortedSetChannel arg0) {
        if (this.channelNum == arg0.channelNum) {
            return 0;
        }
        if (this.channelNum < arg0.channelNum) {
            return -1;
        }
        return 1;
    }

    @Override
    public Iterator<SortedSetSlice> iterator() {
        return this.slices.values().iterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortedSetChannel)) {
            return false;
        }
        SortedSetChannel other = (SortedSetChannel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChannelNum() != other.getChannelNum()) {
            return false;
        }
        TreeMap<Integer, SortedSetSlice> this$slices = this.slices;
        TreeMap<Integer, SortedSetSlice> other$slices = other.slices;
        return !(this$slices == null ? other$slices != null : !((Object)this$slices).equals(other$slices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortedSetChannel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChannelNum();
        TreeMap<Integer, SortedSetSlice> $slices = this.slices;
        result = result * 59 + ($slices == null ? 43 : ((Object)$slices).hashCode());
        return result;
    }

    public int getChannelNum() {
        return this.channelNum;
    }
}

