/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.multifile.buffer;

import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.plugin.io.multifile.SizeExtents;
import org.anchoranalysis.plugin.io.multifile.buffer.MultiBuffer;

public class MultiBufferSized {
    private Dimensions dimensions;
    private int sizeT;
    private MultiBuffer buffers;

    public MultiBufferSized(Stack stack, SizeExtents size) {
        this.buffers = new MultiBuffer(stack, size);
        this.dimensions = new Dimensions(size.toExtent(), stack.resolution());
        this.sizeT = size.getRangeT().getSize();
    }

    public void populateFrom(Stack stackForFile, Optional<Integer> channelNum, Optional<Integer> sliceNum, Optional<Integer> timeIndex) {
        int time = timeIndex.orElse(0);
        if (channelNum.isPresent()) {
            this.buffers.populateWithSpecifiedChannel(stackForFile, channelNum.get(), sliceNum, time);
        } else if (sliceNum.isPresent()) {
            this.buffers.populateWithSpecifiedSlice(stackForFile, sliceNum.get(), time);
        } else {
            this.buffers.populateNoSpecifics(stackForFile, time);
        }
    }

    public TimeSeries createSequence(VoxelDataType dataType) {
        Stream<Stack> stacks = IntStream.range(0, this.sizeT).mapToObj(t -> this.buffers.createStackForIndex(t, this.dimensions, dataType));
        return new TimeSeries(stacks);
    }
}

