/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.naming.interval;

import java.time.format.DateTimeFormatter;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;

public enum DateStyle {
    INCLUDE_ENTIRELY,
    IGNORE_YEAR,
    OMIT;

    private static final String DATE_WITH_YEAR_PATTERN = "yyyy-MM-dd";
    private static final String DATE_WITHOUT_YEAR_PATTERN = "MMM-dd";

    public DateTimeFormatter formatter() {
        if (this == OMIT) {
            throw new AnchorImpossibleSituationException();
        }
        return DateTimeFormatter.ofPattern(this.pattern());
    }

    public String pattern() {
        if (this == INCLUDE_ENTIRELY) {
            return DATE_WITH_YEAR_PATTERN;
        }
        if (this == IGNORE_YEAR) {
            return DATE_WITHOUT_YEAR_PATTERN;
        }
        throw new AnchorImpossibleSituationException();
    }
}

